/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager;

import ibm.nways.analysis.dpCommon.DpNodeDescriptions;
import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.analysis.dpCommon.DpResourceManager;
import ibm.nways.analysis.dpCommon.DpResourceState;
import ibm.nways.analysis.dpCommon.EventFilter;
import ibm.nways.analysis.dpCommon.GraphDefinition;
import ibm.nways.analysis.dpCommon.GraphInstance;
import ibm.nways.analysis.dpCommon.GraphPollingObjectDefinition;
import ibm.nways.analysis.dpCommon.HistoryEvent;
import ibm.nways.analysis.dpCommon.MultipleNodePOAnalysis;
import ibm.nways.analysis.dpCommon.NodeDefinition;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingConfig;
import ibm.nways.analysis.dpCommon.PollingObjectDefinition;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpCommon.ResourceDefinition;
import ibm.nways.analysis.dpCommon.ResourceInstance;
import ibm.nways.analysis.dpCommon.SingleNodeResourceAnalysis;
import ibm.nways.analysis.dpCommon.SortedStringVector;
import ibm.nways.analysis.dpCommon.ThresholdAnalysis;
import ibm.nways.analysis.dpCommon.ViewDefinition;
import ibm.nways.analysis.dpCommon.ViewInstance;
import ibm.nways.analysis.dpEngine.DpInterface;
import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.DpeConfig;
import ibm.nways.analysis.dpEngine.DpeStats;
import ibm.nways.analysis.dpEngine.HistoryTimer;
import ibm.nways.analysis.dpEngine.Weekly;
import ibm.nways.analysis.dpManager.AdminInterface;
import ibm.nways.analysis.dpManager.AppletNotifyInterface;
import ibm.nways.analysis.dpManager.DPEDirectory;
import ibm.nways.analysis.dpManager.DPERange;
import ibm.nways.analysis.dpManager.DatabaseConnection;
import ibm.nways.analysis.dpManager.DatabaseInfo;
import ibm.nways.analysis.dpManager.DpResourceManagerClass;
import ibm.nways.analysis.dpManager.DpeWorkerManager;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.analysis.dpManager.DpmInterface;
import ibm.nways.analysis.dpManager.DpmMiscClient;
import ibm.nways.analysis.dpManager.EventRegistry;
import ibm.nways.analysis.dpManager.HashtableUtil;
import ibm.nways.analysis.dpManager.IPAddress;
import ibm.nways.analysis.dpManager.InitialConfig;
import ibm.nways.analysis.dpManager.JpmRemoteStatus;
import ibm.nways.analysis.dpManager.OrdinalRangeVector;
import ibm.nways.analysis.dpManager.SeparatorUtil;
import ibm.nways.analysis.dpManager.ServerOperations;
import ibm.nways.analysis.dpManager.StatisticalAnalyzer;
import ibm.nways.analysis.dpManager.TripleIndexHashtable;
import ibm.nways.analysis.dpManager.VectorUtil;
import ibm.nways.jdm.CompoundStatusProxy;
import ibm.nways.jdm.JdmDevice;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.NMPlatformDBClient;
import ibm.nways.jdm.NMPlatformDBInterface;
import ibm.nways.jdm.OvObjectListHandler;
import ibm.nways.jdm.OvObjectListHandlerInterface;
import ibm.nways.jdm.OvRemoteListListenerInterface;
import ibm.nways.jdm.RemoteCompoundStatus;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.common.PHashtable;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.InvalidComponentException;
import ibm.nways.nhm.eui.OptionsDialog;
import ibm.nways.nhm.file_server.RemoteFileServerImpl;
import ibm.nways.ras.Traces;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.rmi.registry.RegistryImpl;

public class dpServerImpl
extends UnicastRemoteObject
implements DpmInterface,
DpmClientApplet,
DpmMiscClient,
Runnable,
AdminInterface,
OvRemoteListListenerInterface {
    public static boolean debugFlag = true;
    public static boolean sendToAll;
    private static ResourceBundle adminRB;
    private static final String JDBC_CONNECTION_ERROR;
    private static final String JDBC_CLASS_NOT_FOUND_ERROR;
    private static final String JDBC_SERVER_CONNECTION_ERROR;
    private static final int RECONNECT_PORT = 2098;
    private static final long N_HOURS = 0x6DDD00L;
    private static final int MAX_CONNECT_ATTEMPTS = 10;
    private static dpServerImpl singleton;
    private static String[] versions;
    private int trackWarningLevel = 20;
    private int pointWarningLevel = 1000;
    public static boolean noLocalDPE;
    private int maxConsecutiveFailures = 25;
    private int databaseHistorySize = 100;
    private int nonDatabaseHistorySize = 500;
    private int internalHistorySize = 60;
    private float autoThresholdLevel = 1.4f;
    private int minTimeBetweenSaves = 30;
    private int maxTimeBetweenSaves = 1200;
    private int validSampleInterval = 600;
    private float historyThreshold = 0.8f;
    private int maxNotifyListSize = 100;
    private PollingConfig pollingConfig;
    private int autoLaunchDelayTime = 15;
    boolean jpmAutoLaunchInProgress = false;
    private JpmRemoteStatus remoteStatus;
    private Registry localRegistry;
    private DpInterfaceImpl localDPE;
    private static boolean tracesInitialized;
    private Hashtable dpeStatsTable = new Hashtable();
    private int portNumber = 2099;
    private Object configLock = new Object();
    private PHashtable pollingDefinitionTable;
    private PHashtable pPOITable;
    private PHashtable resourceDefinitionTable;
    private PHashtable pRITable;
    private PHashtable dpeTable;
    private PHashtable dpeConfigTable;
    private PHashtable generalSettingsTable;
    private PHashtable viewDefinitionTable;
    private PHashtable graphDefinitionTable;
    private TripleIndexHashtable pollingInstanceTable = new TripleIndexHashtable();
    private TripleIndexHashtable resourceInstanceTable = new TripleIndexHashtable();
    private EventRegistry theEventRegistry;
    private DatabaseConnection theDatabaseConnection;
    private DPEDirectory theDPEDirectory = new DPEDirectory();
    private static StatisticalAnalyzer statAnalyzer;
    private JdmServerImpl refJdmServer;
    private String configDirectory;
    private boolean registeredWithListHandler = false;

    public dpServerImpl() throws RemoteException {
        this.theEventRegistry = new EventRegistry(this);
    }

    private void restoreDPE(DpInterface dpInterface) {
        try {
            Weekly weekly = (Weekly)this.generalSettingsTable.get("Schedule");
            if (weekly != null) {
                dpInterface.setDpeSchedule(weekly, 3);
                if (dpInterface != null) {
                    dpServerImpl.DM("Schedule set for DPE: " + dpInterface.getHostname().getHostName());
                }
            }
            if (this.connectedToDatabase()) {
                if (dpInterface != null) {
                    dpServerImpl.DM("forwarding histories for DPE: " + dpInterface.getHostname().getHostName());
                }
                this.forwardDPEHistories(true, dpInterface);
            } else {
                if (dpInterface != null) {
                    dpServerImpl.DM("not forwarding histories for DPE: " + dpInterface.getHostname().getHostName());
                }
                this.forwardDPEHistories(false, dpInterface);
            }
            Enumeration enumeration = this.pPOITable.elements();
            String string = dpInterface.getHostname().getHostAddress();
            if (dpInterface != null) {
                dpServerImpl.DM("Restoring PODS/POIS for DPE: " + dpInterface.getHostname().getHostName());
            }
            Vector<PollingObjectInstance> vector = new Vector<PollingObjectInstance>();
            Vector<PollingObjectDefinition> vector2 = new Vector<PollingObjectDefinition>();
            while (enumeration.hasMoreElements()) {
                PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
                if (!this.theDPEDirectory.lookup(pollingObjectInstance.getHostname()).equals(string)) continue;
                if (vector2.indexOf(pollingObjectInstance.getIdentifier()) == -1) {
                    vector2.addElement((PollingObjectDefinition)this.pollingDefinitionTable.get(pollingObjectInstance.getIdentifier()));
                }
                vector.addElement(pollingObjectInstance);
            }
            if (vector2.size() > 0) {
                dpServerImpl.DM("Sending definitions to DPE: " + InetAddress.getByName(string).getHostName());
                dpInterface.addPollingObjectDefinitions(vector2);
            }
            if (vector.size() > 0) {
                dpServerImpl.DM("Sending " + vector.size() + " instances to DPE: " + InetAddress.getByName(string).getHostName());
                dpInterface.addPollingObjectInstances(vector);
                dpServerImpl.DM("*****Configuration sent to DPE: " + InetAddress.getByName(string).getHostName() + ".");
                return;
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl.restoreDPE: an exception occurred:", exception);
        }
    }

    private void restore() {
        try {
            Object object;
            Object object2;
            Enumeration enumeration = this.pPOITable.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (PollingObjectInstance)enumeration.nextElement();
                this.pollingInstanceTable.put(((PollingObjectInstance)object2).getHostname(), ((PollingObjectInstance)object2).getIdentifier(), ((PollingObjectInstance)object2).getLongIndex(), object2);
            }
            if (this.pPOITable.size() > 0) {
                dpServerImpl.DM("pollingInstanceTable restored " + this.pPOITable.size() + " POIs");
            }
            object2 = this.pRITable.elements();
            while (object2.hasMoreElements()) {
                object = (ResourceInstance)object2.nextElement();
                this.resourceInstanceTable.put(((ResourceInstance)object).getHostname(), ((ResourceInstance)object).getDefinition().getIdentifier(), new Long(((ResourceInstance)object).getKey()), object);
            }
            if (this.pRITable.size() > 0) {
                dpServerImpl.DM("ResourceInstanceTable restored " + this.pRITable.size() + " RIs");
            }
            object = this.theDPEDirectory.getDPEList().elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                String string2 = new String("Server UP");
                byte[] byArray = new byte[string2.length()];
                byArray = string2.getBytes();
                DatagramSocket datagramSocket = new DatagramSocket();
                if (string.equals(InetAddress.getLocalHost().getHostAddress())) continue;
                DatagramPacket datagramPacket = new DatagramPacket(byArray, string2.length(), InetAddress.getByName(string), 2098);
                datagramSocket.send(datagramPacket);
                dpServerImpl.DM("UDP packet sent to: " + InetAddress.getByName(string).getHostName());
            }
            if (this.dpeTable.size() > 1) {
                dpServerImpl.DM("All dpe's have been notified...");
                return;
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl.restore: an exception occurred:", exception);
        }
    }

    public void setRMIPort(int n) {
        this.portNumber = n;
    }

    public void run() {
        Object object = this.getConfigLock();
        synchronized (object) {
            try {
                Object object2;
                Object object3;
                Object object4;
                String string;
                String string2;
                Serializable serializable;
                Object object5;
                singleton = this;
                this.configDirectory = "config";
                String string3 = "";
                String string4 = "";
                try {
                    Float f;
                    object5 = new FileInputStream("JdmServerProperties.txt");
                    serializable = new Properties();
                    serializable.load((InputStream)object5);
                    string4 = serializable.getProperty("baseDir");
                    string3 = String.valueOf(string4) + serializable.getProperty("jmaPropertiesSubDir");
                    this.configDirectory = String.valueOf(string3) + "/config";
                    string2 = serializable.getProperty(adminRB.getString("s_maxPerformanceInstances"));
                    string = serializable.getProperty(adminRB.getString("s_maxPerformancePoints"));
                    object4 = serializable.getProperty(adminRB.getString("s_maxConsecutiveFailures"));
                    object3 = serializable.getProperty(adminRB.getString("s_DbHistorySize"));
                    object2 = serializable.getProperty(adminRB.getString("s_NonDbHistorySize"));
                    String string5 = serializable.getProperty(adminRB.getString("s_internalHistorySize"));
                    String string6 = serializable.getProperty(adminRB.getString("s_autoThresholdLevel"));
                    String string7 = serializable.getProperty(adminRB.getString("s_minTimeBetweenSaves"));
                    String string8 = serializable.getProperty(adminRB.getString("s_maxTimeBetweenSaves"));
                    String string9 = serializable.getProperty(adminRB.getString("s_validSampleInterval"));
                    String string10 = serializable.getProperty(adminRB.getString("s_historyThreshold"));
                    String string11 = serializable.getProperty(adminRB.getString("s_maxNotifyListSize"));
                    String string12 = serializable.getProperty("JPMautoLaunchDelay");
                    if (string2 != null) {
                        try {
                            this.trackWarningLevel = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string != null) {
                        try {
                            this.pointWarningLevel = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (object4 != null) {
                        try {
                            this.maxConsecutiveFailures = Integer.parseInt((String)object4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (object3 != null) {
                        try {
                            this.databaseHistorySize = Integer.parseInt((String)object3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (object2 != null) {
                        try {
                            this.nonDatabaseHistorySize = Integer.parseInt((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string5 != null) {
                        try {
                            this.internalHistorySize = Integer.parseInt(string5);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string6 != null) {
                        try {
                            f = new Float(string6);
                            this.autoThresholdLevel = f.floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string7 != null) {
                        try {
                            this.minTimeBetweenSaves = Integer.parseInt(string7);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string8 != null) {
                        try {
                            this.maxTimeBetweenSaves = Integer.parseInt(string8);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string9 != null) {
                        try {
                            this.validSampleInterval = Integer.parseInt(string9);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string10 != null) {
                        try {
                            f = new Float(string10);
                            this.historyThreshold = f.floatValue();
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string11 != null) {
                        try {
                            this.maxNotifyListSize = Integer.parseInt(string11);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (string12 != null) {
                        try {
                            this.autoLaunchDelayTime = Integer.parseInt(string12);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.out.println("Cannot find JdmServerProperties.txt");
                    Traces.logWarning(this, "Cannot find JdmServerProperties.txt");
                }
                catch (IOException iOException) {
                    System.out.println("Error reading properties file: " + iOException.getMessage());
                    Traces.logException(iOException);
                }
                object5 = new String();
                object5 = String.valueOf(string4) + File.separator + "java" + File.separator + "websvr";
                dpServerImpl.DM("config files are located at: " + this.configDirectory);
                dpServerImpl.DM("report files are located at: " + (String)object5);
                this.pollingDefinitionTable = new PHashtable(this.configDirectory, "pollDefTable");
                this.pPOITable = new PHashtable(this.configDirectory, "pollInstTable");
                this.resourceDefinitionTable = new PHashtable(this.configDirectory, "resourceDefTable");
                this.pRITable = new PHashtable(this.configDirectory, "resInstTable");
                this.dpeTable = new PHashtable(this.configDirectory, "dpeTable");
                this.dpeConfigTable = new PHashtable(this.configDirectory, "dpeConfigTable");
                this.generalSettingsTable = new PHashtable(this.configDirectory, "generalSettingsTable");
                this.viewDefinitionTable = new PHashtable(this.configDirectory, "viewDefTable");
                this.graphDefinitionTable = new PHashtable(this.configDirectory, "graphDefTable");
                this.localRegistry = LocateRegistry.getRegistry(this.portNumber);
                if (this.localRegistry == null) {
                    dpServerImpl.DM("Did not find a local registry, creating one...");
                    this.localRegistry = new RegistryImpl(this.portNumber);
                }
                this.localRegistry.rebind("dpServer", this);
                dpServerImpl.DM("JPM Server started and is bound to the name:  dpServer at port " + this.portNumber);
                dpServerImpl.DM("dpServerImpl:run: starting File Server");
                serializable = new RemoteFileServerImpl((String)object5);
                string2 = "RFSI";
                System.err.println("dpServerImpl:run: binding remote file server to name: " + string2);
                this.localRegistry.rebind(string2, (Remote)((Object)serializable));
                string = null;
                if (this.pollingDefinitionTable.size() == 0 && this.resourceDefinitionTable.size() == 0 && this.generalSettingsTable.size() == 0) {
                    int n = 0;
                    while (n < OptionsDialog.REPORT_OPTION_KEYWORDS.length) {
                        this.generalSettingsTable.put(OptionsDialog.REPORT_OPTION_KEYWORDS[n], OptionsDialog.REPORT_OPTION_DEFAULTS[n]);
                        ++n;
                    }
                    this.generalSettingsTable.put("unique_key", new Long(1L));
                    this.theDPEDirectory.addDPEbyRange(new DPERange(InetAddress.getLocalHost().getHostAddress(), IPAddress.toLong("0.0.0.0"), IPAddress.toLong("255.255.255.255")));
                    this.theDPEDirectory.setLocalDPE(InetAddress.getLocalHost().getHostAddress());
                    this.generalSettingsTable.put("DPEDirectory", this.theDPEDirectory);
                } else {
                    string = (String)this.generalSettingsTable.get("Version");
                    if (string == null) {
                        string = "01.00";
                    }
                    if ((object4 = (DatabaseInfo)this.generalSettingsTable.get("DBInfo")) != null) {
                        this.setCollectionStatus((DatabaseInfo)object4);
                    }
                    this.theDPEDirectory = (DPEDirectory)this.generalSettingsTable.get("DPEDirectory");
                }
                String string13 = this.loadCustomization(String.valueOf(string3) + File.separator + "startup" + File.separator, string);
                this.generalSettingsTable.put("Version", string13);
                if (!noLocalDPE) {
                    DpInterfaceImpl.trace = false;
                    this.localDPE = new DpInterfaceImpl(this, this.configDirectory, true, false, true);
                    this.registerDPEngine(this.localDPE);
                    dpServerImpl.DM("Local DPE started");
                }
                this.restore();
                try {
                    this.remoteStatus = new JpmRemoteStatus(this);
                    object3 = new FileInputStream(String.valueOf(this.configDirectory) + File.separator + "pollingConfig");
                    object2 = new ObjectInputStream((InputStream)object3);
                    this.pollingConfig = (PollingConfig)((ObjectInputStream)object2).readObject();
                    this.checkPollingList(false);
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
                catch (IOException iOException) {
                    this.pollingConfig = new PollingConfig();
                    this.checkPollingList(true);
                }
            }
            catch (Exception exception) {
                dpServerImpl.DM("dpServerImpl:run: an exception occurred:", exception);
            }
            return;
        }
    }

    private void checkPollingList(boolean bl) {
        Vector vector;
        OvObjectListHandler ovObjectListHandler = null;
        try {
            if (this.pollingConfig.sysOidsToPoll.size() > 0 || this.pollingConfig.nodesToPoll.size() > 0 || this.registeredWithListHandler) {
                int n = 0;
                while (ovObjectListHandler == null && n < 10) {
                    ovObjectListHandler = (OvObjectListHandler)JdmServerImpl.getSingleton().getService((Object)"OvObjectListHandler");
                    try {
                        if (ovObjectListHandler == null) {
                            Thread.sleep(20000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    ++n;
                }
            }
            if (ovObjectListHandler != null) {
                Vector<JdmDevice> vector2 = new Vector<JdmDevice>();
                vector = this.getPollingNodeList();
                if (vector == null) {
                    vector = new Vector();
                }
                if (!this.registeredWithListHandler) {
                    ovObjectListHandler.registerForOvListUpdates((OvRemoteListListenerInterface)this);
                    this.registeredWithListHandler = true;
                } else if (this.pollingConfig.sysOidsToPoll.size() == 0 && this.pollingConfig.nodesToPoll.size() == 0) {
                    ovObjectListHandler.deregisterForOvListUpdates((OvRemoteListListenerInterface)this);
                    this.registeredWithListHandler = false;
                }
                Vector vector3 = ovObjectListHandler.getDbObjectList();
                Enumeration enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    JdmDevice jdmDevice = (JdmDevice)enumeration.nextElement();
                    String string = (String)jdmDevice.getDeviceType();
                    String string2 = (String)jdmDevice.getAddress();
                    if (string2 == null) continue;
                    if (this.pollingConfig.pollDevice(string, string2)) {
                        if (vector.contains(string2)) continue;
                        vector2.addElement(jdmDevice);
                        continue;
                    }
                    if (!vector.contains(string2)) continue;
                    System.out.println("Calling unManageNode for " + string2);
                    this.unManageNode(string2);
                }
                if (vector2.size() > 0) {
                    this.beginPolling(vector2);
                }
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("", exception);
        }
        if (bl) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(this.configDirectory) + File.separator + "pollingConfig");
                vector = new ObjectOutputStream(fileOutputStream);
                ((ObjectOutputStream)((Object)vector)).writeObject(this.pollingConfig);
                return;
            }
            catch (IOException iOException) {
                dpServerImpl.DM("", iOException);
                return;
            }
        }
    }

    public boolean ovListReady() {
        return true;
    }

    public boolean ovObjectAdded(JdmDevice jdmDevice) {
        if (this.pollingConfig != null && this.pollingConfig.pollDevice((String)jdmDevice.getDeviceType(), (String)jdmDevice.getAddress())) {
            this.beginPolling(jdmDevice);
        }
        return true;
    }

    public boolean ovObjectDeleted(JdmDevice jdmDevice) {
        block2: {
            Enumeration enumeration = this.pollingInstanceTable.get(jdmDevice.getAddress());
            if (enumeration == null || !enumeration.hasMoreElements()) break block2;
            try {
                this.unManageNode((String)jdmDevice.getAddress());
            }
            catch (RemoteException remoteException) {}
        }
        return true;
    }

    private void beginPolling(Vector vector) {
        Enumeration enumeration = vector.elements();
        System.out.println("starting JPM Auto Launch");
        this.jpmAutoLaunchInProgress = true;
        try {
            while (enumeration.hasMoreElements()) {
                this.beginPolling((JdmDevice)enumeration.nextElement());
            }
            try {
                Thread.sleep(this.autoLaunchDelayTime * 1000);
            }
            catch (InterruptedException interruptedException) {}
            this.jpmAutoLaunchInProgress = false;
            System.out.println("ending JPM Auto Launch");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.jpmAutoLaunchInProgress = false;
            return;
        }
    }

    private void beginPolling(JdmDevice jdmDevice) {
        String string = null;
        String string2 = NMPlatformDBClient.getClassName(jdmDevice.getToken());
        int n = string2.indexOf(".class");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        if ((string = string2.substring((n = string2.lastIndexOf(".")) + 1).equals("GenericJdm") ? String.valueOf(string2.substring(0, n)) + ".model.Generic" : (string2.substring(n + 1).equals("Jdm8239") ? String.valueOf(string2.substring(0, n)) + ".model.Jdm8239Folder" : String.valueOf(string2.substring(0, n)) + ".model" + string2.substring(n))) != null) {
            try {
                GenModel genModel;
                if (this.refJdmServer == null) {
                    this.refJdmServer = JdmServerImpl.getSingleton();
                }
                String string3 = "ov " + jdmDevice.getToken();
                GenModel genModel2 = (GenModel)this.refJdmServer.getModelFor(string3, string, (RemoteStatus)this.remoteStatus);
                String string4 = "ConfigurationFolder";
                try {
                    genModel = (GenModel)genModel2.getComponent(string4);
                }
                catch (InvalidComponentException invalidComponentException) {
                    string4 = "Configuration";
                    try {
                        genModel = (GenModel)genModel2.getComponent(string4);
                    }
                    catch (InvalidComponentException invalidComponentException2) {
                        string4 = "P1Configuration";
                        genModel = (GenModel)genModel2.getComponent(string4);
                    }
                }
                RemoteStatus remoteStatus = null;
                if (genModel != null && genModel instanceof RemoteModelWithStatus) {
                    remoteStatus = genModel.getStatus();
                    new CompoundStatusProxy((RemoteCompoundStatus)remoteStatus);
                    return;
                }
                System.out.println("[dpServerImpl] configFolderModel == null or not instance of RemoteModelWithStatus");
                return;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        System.out.println("[dpServerImpl] Couldn't get the model name for " + string2);
    }

    public PollingConfig getPollingConfiguration() throws RemoteException {
        return this.pollingConfig;
    }

    public void pollingConfigurationChanged(PollingConfig pollingConfig) throws RemoteException {
        this.pollingConfig = pollingConfig;
        this.checkPollingList(true);
    }

    public void jmaClosingCheckPolling(String string) throws RemoteException {
        try {
            if (this.pollingConfig != null) {
                String string2;
                if (this.refJdmServer == null) {
                    this.refJdmServer = JdmServerImpl.getSingleton();
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                String string3 = stringTokenizer.nextToken();
                JdmDevice jdmDevice = null;
                int n = 0;
                NMPlatformDBInterface nMPlatformDBInterface = (NMPlatformDBInterface)((Object)this.refJdmServer.getService((Object)"NMPlatformDB"));
                if (string3.equals("ov")) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                } else if (string3.equals("snmp")) {
                    string2 = nMPlatformDBInterface.getDBId(stringTokenizer.nextToken());
                    n = Integer.parseInt(string2);
                } else {
                    System.out.println("[dpServerImpl.closingJmaCheckPolling]: Unexpected instrumentation context: " + string);
                }
                jdmDevice = new JdmDevice(n, (OvObjectListHandlerInterface)((Object)this.refJdmServer.getService((Object)"OvObjectListHandler")), nMPlatformDBInterface);
                string2 = (String)jdmDevice.getAddress();
                if (!this.pollingConfig.pollDevice((String)jdmDevice.getDeviceType(), string2)) {
                    this.unManageNode(string2);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String loadCustomization(String string, String string2) {
        InitialConfig initialConfig = null;
        String string3 = versions[versions.length - 1];
        if (string2 == null) {
            initialConfig = new InitialConfig(this, string);
        } else {
            int n = 0;
            while (n < versions.length) {
                if (string2.compareTo(versions[n]) < 0) {
                    initialConfig = new InitialConfig(this, String.valueOf(string) + versions[n] + File.separator);
                }
                ++n;
            }
        }
        return string3;
    }

    public void shutdown() {
        dpServerImpl.DM("*---------DpManager Shutdown Start--------*");
        if (this.theDatabaseConnection != null && this.theDatabaseConnection.isCollecting()) {
            dpServerImpl.DM("-->Closing the database connection");
            try {
                this.setCollectionStatus(new DatabaseInfo(null, null, false));
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        if (this.theEventRegistry != null) {
            dpServerImpl.DM("-->Removing all event listeners");
            this.theEventRegistry.removeAllListeners();
        }
        if (this.localDPE != null) {
            try {
                this.localDPE.shutdownDPE();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
        dpServerImpl.DM("*---------DpManager Shutdown Complete--------*");
    }

    public String getReportSetting(String string) throws RemoteException {
        return (String)this.generalSettingsTable.get(string);
    }

    public void setReportSetting(String string, String string2) throws RemoteException {
        this.generalSettingsTable.put(string, string2);
    }

    public Date getCurrentTime() throws RemoteException {
        return new Date();
    }

    public Hashtable getDpeStats() throws RemoteException {
        return this.dpeStatsTable;
    }

    private void forwardDPEHistories(boolean bl) {
        Enumeration enumeration = this.dpeTable.elements();
        while (enumeration.hasMoreElements()) {
            DpInterface dpInterface = (DpInterface)enumeration.nextElement();
            this.forwardDPEHistories(bl, dpInterface);
        }
    }

    public HistoryTimer getDPEHistoryTimer(String string) throws RemoteException {
        HistoryTimer historyTimer;
        block6: {
            Object object;
            Object object2 = null;
            historyTimer = null;
            Enumeration enumeration = this.dpeTable.elements();
            while (enumeration.hasMoreElements() && object2 == null) {
                object = (DpInterface)enumeration.nextElement();
                try {
                    String string2 = object.getHostname().getHostAddress();
                    String string3 = InetAddress.getByName(string).getHostAddress();
                    if (!string3.equals(string2)) continue;
                    object2 = object;
                }
                catch (UnknownHostException unknownHostException) {
                    dpServerImpl.DM("dpServerImpl:getDPEHistoryTimer: exception occurred", unknownHostException);
                }
            }
            if (object2 == null) break block6;
            try {
                object = object2.getDpeConfig();
                if (object != null) {
                    historyTimer = ((DpeConfig)object).historyTimer;
                }
            }
            catch (Exception exception) {
                dpServerImpl.DM("dpServerImpl:getDPEHistoryTimer: exception occurred", exception);
            }
        }
        return historyTimer;
    }

    public void setDPEHistoryTimer(String string, HistoryTimer historyTimer) throws RemoteException {
        Object object;
        Object object2 = null;
        String string2 = null;
        Enumeration enumeration = this.dpeTable.elements();
        while (enumeration.hasMoreElements() && object2 == null) {
            object = (DpInterface)enumeration.nextElement();
            try {
                String string3 = object.getHostname().getHostAddress();
                String string4 = InetAddress.getByName(string).getHostAddress();
                if (!string4.equals(string3)) continue;
                object2 = object;
                string2 = string3;
            }
            catch (UnknownHostException unknownHostException) {
                dpServerImpl.DM("dpServerImpl:getDPEHistoryTimer: exception occurred", unknownHostException);
            }
        }
        if (object2 != null) {
            try {
                object = object2.getDpeConfig();
                ((DpeConfig)object).historyTimer = historyTimer;
                object2.setDpeConfig((DpeConfig)object);
                this.dpeConfigTable.put(string2, object);
                return;
            }
            catch (Exception exception) {
                dpServerImpl.DM("dpServerImpl:setDPEHistoryTimer: exception occurred", exception);
                return;
            }
        }
    }

    private void forwardDPEHistories(boolean bl, DpInterface dpInterface) {
        try {
            DpeConfig dpeConfig = dpInterface.getDpeConfig();
            dpeConfig.sendHistoryWithEvent = bl;
            dpeConfig.historySize = bl ? this.databaseHistorySize : this.nonDatabaseHistorySize;
            dpInterface.setDpeConfig(dpeConfig);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setSchedule(Weekly weekly) throws RemoteException {
        try {
            Enumeration enumeration = this.dpeTable.elements();
            while (enumeration.hasMoreElements()) {
                DpInterface dpInterface = (DpInterface)enumeration.nextElement();
                if (dpInterface.setDpeSchedule(weekly, 3)) {
                    dpServerImpl.DM("new schedule sent to dpe: " + dpInterface.getHostname());
                    this.generalSettingsTable.put("Schedule", weekly);
                    continue;
                }
                dpServerImpl.DM("error sending new schedule to dpe: " + dpInterface.getHostname());
            }
            return;
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:setSchedule: exception occurred", exception);
            return;
        }
    }

    public DatabaseConnection getDBC() {
        return this.theDatabaseConnection;
    }

    public synchronized DatabaseInfo getCollectionStatus() throws RemoteException {
        if (this.theDatabaseConnection != null) {
            return (DatabaseInfo)this.theDatabaseConnection.clone();
        }
        return null;
    }

    private synchronized boolean connectedToDatabase() {
        boolean bl = false;
        if (this.theDatabaseConnection != null && this.theDatabaseConnection.isCollecting()) {
            bl = true;
        } else {
            try {
                DatabaseInfo databaseInfo = (DatabaseInfo)this.generalSettingsTable.get("DBInfo");
                if (databaseInfo != null) {
                    this.setCollectionStatus(databaseInfo);
                    bl = true;
                }
            }
            catch (Exception exception) {
                dpServerImpl.DM(exception.getMessage());
            }
        }
        return bl;
    }

    public synchronized String setCollectionStatus(DatabaseInfo databaseInfo) throws RemoteException {
        String string = null;
        try {
            if (this.theDatabaseConnection == null || !this.theDatabaseConnection.isCollecting() && databaseInfo.isCollecting()) {
                dpServerImpl.DM("Connecting to database");
                this.theDatabaseConnection = new DatabaseConnection(databaseInfo, this);
                this.generalSettingsTable.put("DBInfo", databaseInfo);
                this.forwardDPEHistories(true);
            } else if (this.theDatabaseConnection != null && this.theDatabaseConnection.isCollecting() && !databaseInfo.isCollecting()) {
                dpServerImpl.DM("Closing the database connection");
                this.theDatabaseConnection.close();
                if (databaseInfo.getDriverName() != null && databaseInfo.getDatabaseURL() != null) {
                    this.generalSettingsTable.remove("DBInfo");
                }
                this.forwardDPEHistories(false);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            string = JDBC_CLASS_NOT_FOUND_ERROR;
            this.theDatabaseConnection = null;
            dpServerImpl.DM(string);
        }
        catch (RemoteException remoteException) {
            string = JDBC_SERVER_CONNECTION_ERROR;
            this.theDatabaseConnection = null;
            dpServerImpl.DM(string);
        }
        catch (SQLException sQLException) {
            string = JDBC_CONNECTION_ERROR;
            this.theDatabaseConnection = null;
            dpServerImpl.DM(string);
            dpServerImpl.DM(sQLException.getMessage());
        }
        return string;
    }

    public void cleanupDatabaseConnection() {
        this.theDatabaseConnection = null;
    }

    public void historyNotify(HistoryEvent historyEvent) throws RemoteException {
        String string = null;
        try {
            string = this.theDPEDirectory.lookup(historyEvent.getInstID());
        }
        catch (UnknownHostException unknownHostException) {}
        try {
            string = InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        if (string != null) {
            dpServerImpl.DM("No database, data being overwritten for : " + historyEvent.getDefID() + " : " + historyEvent.getInstID() + " on DPE " + string);
            return;
        }
        dpServerImpl.DM("No database, data being overwritten for : " + historyEvent.getDefID() + " : " + historyEvent.getInstID());
    }

    public boolean historyNotify(PollingObjectInstance pollingObjectInstance) throws RemoteException {
        boolean bl = false;
        try {
            if (this.connectedToDatabase()) {
                this.theDatabaseConnection.insertDatabaseWork(pollingObjectInstance);
                bl = true;
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:historyNotify:exception thrown", exception);
        }
        return bl;
    }

    public void statisticsNotify(DpeStats dpeStats) throws RemoteException {
        this.dpeStatsTable.put(dpeStats.getHostname(), dpeStats);
    }

    public void registerDPEngine(DpInterface dpInterface) throws RemoteException {
        try {
            if (dpInterface == null) {
                dpServerImpl.DM("Can't register DPE, the remote backward interface is null");
                return;
            }
            String string = dpInterface.getHostname().getHostAddress();
            DpeConfig dpeConfig = (DpeConfig)this.dpeConfigTable.get(string);
            if ((DpInterface)this.dpeTable.get(string) != null) {
                dpServerImpl.DM("Found an old reference of " + InetAddress.getByName(string).getHostName() + ", cleaning up and restoring.");
                this.dpeTable.remove(string);
            }
            dpServerImpl.DM("Saving reference to dpe : " + InetAddress.getByName(string).getHostName());
            this.dpeTable.put(string, dpInterface);
            this.restoreDPE(dpInterface);
            if (dpeConfig == null) {
                int n = 500;
                n = this.connectedToDatabase() ? this.databaseHistorySize : this.nonDatabaseHistorySize;
                dpeConfig = new DpeConfig(true, this.maxConsecutiveFailures, n, this.internalHistorySize, this.autoThresholdLevel, this.minTimeBetweenSaves, this.maxTimeBetweenSaves, this.validSampleInterval, this.historyThreshold, this.maxNotifyListSize, true);
                this.dpeConfigTable.put(string, dpeConfig);
            }
            dpInterface.setDpeConfig(dpeConfig);
            return;
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:registerDPEngine:exception thrown", exception);
            return;
        }
    }

    public void eventNotify(PerformanceEvent performanceEvent) throws RemoteException {
        this.theEventRegistry.insertEvent(performanceEvent);
    }

    public void eventNotify(Vector vector) throws RemoteException {
        this.theEventRegistry.insertEvent(vector);
    }

    public DPEDirectory lockDPEConfig(boolean bl) throws RemoteException {
        return this.theDPEDirectory.copy();
    }

    public boolean updateDPEConfig(DPEDirectory dPEDirectory) throws RemoteException {
        boolean bl = true;
        if (this.theDPEDirectory.getKey() == dPEDirectory.getKey()) {
            Object object = this.getConfigLock();
            synchronized (object) {
                dpServerImpl.DM("------------------UnLocking dpe config");
                ServerOperations serverOperations = DPEDirectory.findDelta(this.theDPEDirectory, dPEDirectory);
                this.processNodeDistribution(serverOperations);
                this.generalSettingsTable.put("DPEDirectory", dPEDirectory);
                this.theDPEDirectory = dPEDirectory;
            }
        } else {
            dpServerImpl.DM("DpAdmin gave the server a Directory with an invalid access key: " + dPEDirectory.getKey());
            dpServerImpl.DM("The Directory expected was one with access key: " + this.theDPEDirectory.getKey());
            bl = false;
        }
        return bl;
    }

    private Vector getPOIs(String string) {
        Vector vector = new Vector();
        Enumeration enumeration = this.pollingInstanceTable.get(string);
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Enumeration enumeration2 = this.pollingInstanceTable.getElements(string, string2);
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                vector.addElement(enumeration2.nextElement());
            }
        }
        return vector;
    }

    private void processNodeDistribution(ServerOperations serverOperations) {
        if (this.pollingInstanceTable != null) {
            Enumeration enumeration = this.pollingInstanceTable.keys();
            OrdinalRangeVector ordinalRangeVector = serverOperations.getAddRanges();
            OrdinalRangeVector ordinalRangeVector2 = serverOperations.getRemoveRanges();
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            while (enumeration.hasMoreElements()) {
                DPERange dPERange;
                String string = (String)enumeration.nextElement();
                DPERange dPERange2 = ordinalRangeVector.lookup(IPAddress.toLong(string));
                if (dPERange2 != null) {
                    vector = VectorUtil.unionOfTwoVectors(this.getPOIs(string), vector);
                }
                if ((dPERange = ordinalRangeVector2.lookup(IPAddress.toLong(string))) == null) continue;
                vector2 = VectorUtil.unionOfTwoVectors(this.getPOIs(string), vector2);
            }
            this.addPollingObjectInstances(vector, false, ordinalRangeVector);
            this.removePollingObjectInstances(vector2, true, false, ordinalRangeVector2);
        }
    }

    private boolean pollingObjectDefinitionsExist(Vector vector) throws RemoteException {
        boolean bl = true;
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                if (this.pollingDefinitionTable.get((String)vector.elementAt(n)) == null) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (!bl) {
            dpServerImpl.DM("PODExist: polling definition vector invalid");
        }
        return bl;
    }

    public boolean modifyViewDefinition(String string, Vector vector, Vector vector2, long l, int n) throws RemoteException {
        String string2;
        Enumeration enumeration;
        ViewDefinition viewDefinition = (ViewDefinition)this.viewDefinitionTable.get(string);
        viewDefinition.setPeriodEnding(l, n);
        if (vector2 != null) {
            enumeration = vector2.elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                int n2 = viewDefinition.getGraphs().indexOf(string2);
                if (n2 <= -1) continue;
                viewDefinition.getGraphs().removeElementAt(n2);
            }
            dpServerImpl.DM("deleted defs from view definition: " + string);
        }
        if (vector != null) {
            enumeration = vector.elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                viewDefinition.getGraphs().addElement(string2);
            }
            dpServerImpl.DM("added defs from view definition: " + string);
        }
        this.viewDefinitionTable.put(viewDefinition.getIdentifier(), viewDefinition);
        return true;
    }

    public boolean addViewDefinition(ViewDefinition viewDefinition) throws RemoteException {
        dpServerImpl.DM("Adding view definition: " + viewDefinition.getIdentifier());
        Vector vector = viewDefinition.getGraphs();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            Vector<String> vector2 = new Vector<String>();
            Object e = vector.firstElement();
            if (e != null && e instanceof GraphDefinition) {
                while (enumeration != null && enumeration.hasMoreElements()) {
                    GraphDefinition graphDefinition = (GraphDefinition)enumeration.nextElement();
                    GraphDefinition graphDefinition2 = (GraphDefinition)this.graphDefinitionTable.get(graphDefinition.getGraphName());
                    vector2.addElement(graphDefinition.getGraphName());
                    if (graphDefinition2 != null) continue;
                    dpServerImpl.DM("Adding New Graph Definition: " + graphDefinition.getGraphName());
                    this.graphDefinitionTable.put(graphDefinition.getGraphName(), graphDefinition);
                }
                viewDefinition.setGraphs(vector2);
            }
        }
        this.viewDefinitionTable.put(viewDefinition.getIdentifier(), viewDefinition);
        return true;
    }

    public boolean addViewDefinition(String string, Vector vector) throws RemoteException {
        ViewDefinition viewDefinition = new ViewDefinition(string);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            Vector<String> vector2 = new Vector<String>();
            while (enumeration != null && enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                GraphDefinition cfr_ignored_0 = (GraphDefinition)this.graphDefinitionTable.get(string2);
                vector2.addElement(string2);
            }
            dpServerImpl.DM("added view definition: " + string);
            viewDefinition.setGraphs(vector2);
        }
        this.viewDefinitionTable.put(viewDefinition.getIdentifier(), viewDefinition);
        return true;
    }

    public String removeViewDefinition(String string) throws RemoteException {
        Enumeration enumeration = this.resourceDefinitionTable.elements();
        String string2 = null;
        while (enumeration != null && enumeration.hasMoreElements() && string2 == null) {
            ResourceDefinition resourceDefinition = (ResourceDefinition)enumeration.nextElement();
            if (resourceDefinition.getViewsVector().indexOf(string) == -1) continue;
            string2 = resourceDefinition.getIdentifier();
        }
        if (string2 == null) {
            dpServerImpl.DM("Removing viewDefinition: " + string);
            this.viewDefinitionTable.remove(string);
        }
        return string2;
    }

    public Vector getGraphNamesList() throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        Enumeration enumeration = this.graphDefinitionTable.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            sortedStringVector.addString(((GraphDefinition)enumeration.nextElement()).getGraphName());
        }
        if (sortedStringVector.size() == 0) {
            sortedStringVector = null;
        }
        return sortedStringVector;
    }

    public boolean addGraphDefinition(GraphDefinition graphDefinition) throws RemoteException {
        this.graphDefinitionTable.put(graphDefinition.getGraphName(), graphDefinition);
        return true;
    }

    public String removeGraphDefinition(String string) throws RemoteException {
        Enumeration enumeration = this.viewDefinitionTable.elements();
        String string2 = null;
        while (enumeration != null && enumeration.hasMoreElements() && string2 == null) {
            ViewDefinition viewDefinition = (ViewDefinition)enumeration.nextElement();
            if (viewDefinition.getGraphs().indexOf(string) == -1) continue;
            string2 = viewDefinition.getIdentifier();
        }
        if (string2 == null) {
            this.graphDefinitionTable.remove(string);
        }
        return string2;
    }

    public boolean modifyGraphDefinition(String string, int n, String string2, Vector vector, Vector vector2) throws RemoteException {
        GraphDefinition graphDefinition = (GraphDefinition)this.graphDefinitionTable.get(string);
        if (graphDefinition != null) {
            Enumeration enumeration;
            graphDefinition.setGraphType(n);
            graphDefinition.setUnits(string2);
            if (vector2 != null) {
                enumeration = vector2.elements();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    graphDefinition.getPollingObjects().remove((String)enumeration.nextElement());
                }
                dpServerImpl.DM("deleted defs from view definition: " + string);
            }
            if (vector != null) {
                enumeration = vector.elements();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    GraphPollingObjectDefinition graphPollingObjectDefinition = new GraphPollingObjectDefinition(string3);
                    graphDefinition.addPollingObject(graphPollingObjectDefinition);
                }
                dpServerImpl.DM("added defs from view definition: " + string);
            }
            dpServerImpl.DM("modified graph definition: " + string);
            this.graphDefinitionTable.put(graphDefinition.getGraphName(), graphDefinition);
        } else {
            dpServerImpl.DM("An attempt was made to modify a nonexistant graph definition");
        }
        return true;
    }

    public GraphDefinition getGraphDefinition(String string) throws RemoteException {
        return (GraphDefinition)this.graphDefinitionTable.get(string);
    }

    public void dumpViewDefTable() {
        dpServerImpl.DM("View Definition Table");
        if (this.viewDefinitionTable != null) {
            Enumeration enumeration = this.viewDefinitionTable.elements();
            while (enumeration != null && enumeration.hasMoreElements()) {
                dpServerImpl.DM(((ViewDefinition)enumeration.nextElement()).toString());
            }
        }
    }

    public ViewDefinition getViewDefinition(String string) throws RemoteException {
        ViewDefinition viewDefinition = (ViewDefinition)this.viewDefinitionTable.get(string);
        ViewDefinition viewDefinition2 = null;
        if (viewDefinition != null && viewDefinition.getGraphs() != null) {
            viewDefinition2 = new ViewDefinition(string);
            Vector<GraphDefinition> vector = new Vector<GraphDefinition>();
            Enumeration enumeration = viewDefinition.getGraphs().elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                GraphDefinition graphDefinition = (GraphDefinition)this.graphDefinitionTable.get(string2);
                graphDefinition.setPeriodEnding(viewDefinition.getPeriodEndingNumber(), viewDefinition.getPeriodEndingUnits());
                vector.addElement(graphDefinition);
            }
            viewDefinition2.setGraphs(vector);
            viewDefinition2.setPeriodEnding(viewDefinition.getPeriodEndingNumber(), viewDefinition.getPeriodEndingUnits());
        }
        return viewDefinition2;
    }

    public Vector getViewNames(String string, String string2) throws RemoteException {
        SortedStringVector sortedStringVector = null;
        ResourceDefinition resourceDefinition = (ResourceDefinition)this.resourceDefinitionTable.get(string2);
        if (resourceDefinition != null && resourceDefinition.getDeviceTypes() != null && (resourceDefinition.getDeviceTypes().indexOf("ALL") != -1 || resourceDefinition.getDeviceTypes().indexOf(string) != -1)) {
            sortedStringVector = new SortedStringVector(resourceDefinition.getViewsVector());
        }
        return sortedStringVector;
    }

    public Vector getViewNamesList() throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        Enumeration enumeration = this.viewDefinitionTable.keys();
        while (enumeration.hasMoreElements()) {
            sortedStringVector.addString((String)enumeration.nextElement());
        }
        return sortedStringVector;
    }

    public ViewInstance getViewInstance(String string, String string2, DpResourceInstance dpResourceInstance, long l, long l2) throws RemoteException {
        return this.getViewInstance(string, string2, dpResourceInstance, l, l2, false);
    }

    public ViewInstance getViewInstance(String string, String string2, DpResourceInstance dpResourceInstance, long l, long l2, boolean bl) throws RemoteException {
        DpNodeDescriptions dpNodeDescriptions = new DpNodeDescriptions();
        dpNodeDescriptions.dpAddHostname(string2);
        return this.getViewInstance(string, dpNodeDescriptions, dpResourceInstance, l, l2, bl);
    }

    public ViewInstance getViewInstance(String string, String string2, DpResourceInstance dpResourceInstance) throws RemoteException {
        return this.getViewInstance(string, string2, dpResourceInstance, false);
    }

    public ViewInstance getViewInstance(String string, String string2, DpResourceInstance dpResourceInstance, boolean bl) throws RemoteException {
        DpNodeDescriptions dpNodeDescriptions = new DpNodeDescriptions();
        dpNodeDescriptions.dpAddHostname(string2);
        ViewDefinition viewDefinition = this.getViewDefinition(string);
        long l = System.currentTimeMillis();
        long l2 = -1L;
        long l3 = viewDefinition.getPeriodEndingNumber();
        switch (viewDefinition.getPeriodEndingUnits()) {
            case 1: {
                l2 = l - l3 * 60000L;
                break;
            }
            case 2: {
                l2 = l - l3 * 3600000L;
                break;
            }
            case 3: {
                l2 = l - l3 * 86400000L;
                break;
            }
            case 4: {
                l2 = l - l3 * 604800000L;
                break;
            }
            case 5: {
                l2 = l - l3 * 86400000L * 30L;
                break;
            }
            case 6: {
                l2 = l - l3 * 31449600000L;
                break;
            }
        }
        return this.getViewInstance(string, dpNodeDescriptions, dpResourceInstance, l2, l, viewDefinition, bl);
    }

    public ViewInstance getViewInstance(String string, DpNodeDescriptions dpNodeDescriptions, DpResourceInstance dpResourceInstance, long l, long l2) throws RemoteException {
        return this.getViewInstance(string, dpNodeDescriptions, dpResourceInstance, l, l2, false);
    }

    public ViewInstance getViewInstance(String string, DpNodeDescriptions dpNodeDescriptions, DpResourceInstance dpResourceInstance, long l, long l2, boolean bl) throws RemoteException {
        ViewDefinition viewDefinition = this.getViewDefinition(string);
        return this.getViewInstance(string, dpNodeDescriptions, dpResourceInstance, l, l2, viewDefinition, bl);
    }

    private ViewInstance getViewInstance(String string, DpNodeDescriptions dpNodeDescriptions, DpResourceInstance dpResourceInstance, long l, long l2, ViewDefinition viewDefinition, boolean bl) throws RemoteException {
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        long l4 = 0L;
        int n3 = 0;
        Vector vector = viewDefinition.getGraphs();
        ViewInstance viewInstance = new ViewInstance(viewDefinition.getIdentifier());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            GraphDefinition graphDefinition = (GraphDefinition)enumeration.nextElement();
            GraphInstance graphInstance = new GraphInstance(graphDefinition.getGraphName(), graphDefinition.getGraphType(), graphDefinition.getUnits());
            Hashtable hashtable = graphDefinition.getPollingObjects();
            if (bl) {
                n = hashtable.size();
            }
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                int n4;
                Object object;
                GraphPollingObjectDefinition graphPollingObjectDefinition = (GraphPollingObjectDefinition)enumeration2.nextElement();
                if (bl && l >= 0L && l3 == 0L && (object = (PollingObjectDefinition)this.pollingDefinitionTable.get(graphPollingObjectDefinition.getIdentifier())) != null && (n4 = ((PollingObjectDefinition)object).getNotifyObject().getPollingInterval()) > 0) {
                    l3 = Math.round((l2 - l) / (long)(1000 * n4));
                }
                object = dpNodeDescriptions.elements();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    String string3 = null;
                    String string4 = null;
                    int n5 = 0;
                    n5 = string2.indexOf(61);
                    if (n5 > 0) {
                        string4 = string2.substring(0, n5).trim();
                        string3 = string2.substring(n5 + 1).trim();
                    } else {
                        string3 = string2;
                    }
                    if (!graphPollingObjectDefinition.usedForAllNodes() && !graphPollingObjectDefinition.setForThisNode(string4)) continue;
                    Vector vector2 = null;
                    Vector<String> vector3 = new Vector<String>();
                    Hashtable hashtable2 = graphPollingObjectDefinition.getInstanceData();
                    Vector vector4 = this.getPollingObjectIndices(graphPollingObjectDefinition.getIdentifier(), string3);
                    if (vector4 == null) {
                        if (bl) {
                            n3 = n;
                            l4 = (long)n3 * l3;
                            if (n3 > this.trackWarningLevel || l4 > (long)this.pointWarningLevel) {
                                viewInstance.setFlag(1);
                                viewInstance.setNumInstances(n3);
                                viewInstance.setNumPoints(l4);
                                return viewInstance;
                            }
                        }
                        vector2 = this.getPollingObjectInstances(graphPollingObjectDefinition.getIdentifier(), string3, null, l, l2);
                    } else {
                        String string5;
                        Object object2;
                        String string6 = null;
                        Enumeration enumeration3 = null;
                        Enumeration enumeration4 = null;
                        if (!hashtable2.isEmpty()) {
                            string6 = new String();
                            enumeration3 = hashtable2.keys();
                            enumeration4 = hashtable2.elements();
                            while (enumeration3.hasMoreElements()) {
                                object2 = (String)enumeration3.nextElement();
                                string5 = (String)enumeration4.nextElement();
                                if (string5.startsWith("[")) {
                                    String string7 = null;
                                    if (dpResourceInstance != null) {
                                        string7 = (String)dpResourceInstance.get(object2);
                                    }
                                    if (string7 != null) {
                                        if (string6.length() != 0) {
                                            string6.concat(".");
                                        }
                                        string6.concat(string7);
                                        continue;
                                    }
                                    break;
                                }
                                if (string6.length() != 0) {
                                    string6.concat(".");
                                }
                                string6.concat(string5);
                            }
                        } else if (dpResourceInstance != null && !dpResourceInstance.isEmpty()) {
                            string6 = dpResourceInstance.getIndexString();
                        }
                        object2 = vector4.elements();
                        while (object2.hasMoreElements()) {
                            string5 = (String)object2.nextElement();
                            if (string6 != null && !string5.startsWith(string6)) continue;
                            vector3.addElement(string5);
                        }
                        if (!vector3.isEmpty()) {
                            if (bl) {
                                n2 = vector3.size();
                                n3 = n * n2;
                                l4 = (long)n3 * l3;
                                if (n3 > this.trackWarningLevel || l4 > (long)this.pointWarningLevel) {
                                    viewInstance.setFlag(1);
                                    viewInstance.setNumInstances(n3);
                                    viewInstance.setNumPoints(l4);
                                    return viewInstance;
                                }
                            }
                            vector2 = this.getPollingObjectInstances(graphPollingObjectDefinition.getIdentifier(), string3, vector3, l, l2);
                        }
                    }
                    if (vector2 == null) continue;
                    graphInstance.addPollingObjectInstances(vector2);
                }
            }
            if (graphInstance == null) continue;
            viewInstance.addGraph(graphInstance);
        }
        return viewInstance;
    }

    public boolean addNodeDefinition(NodeDefinition nodeDefinition) throws RemoteException {
        dpServerImpl.DM("Node definitions not implemented at this time:  Cannot add " + nodeDefinition.toString());
        return true;
    }

    public boolean addTemplateDefinitionsToResource(Vector vector, Vector vector2, String string, String string2) throws RemoteException {
        boolean bl = false;
        ResourceDefinition resourceDefinition = (ResourceDefinition)this.resourceDefinitionTable.get(string2);
        if (resourceDefinition != null && (vector != null || vector2 != null)) {
            Object e;
            Enumeration enumeration;
            Vector vector3;
            if (vector != null) {
                vector3 = resourceDefinition.getDefinitionVector();
                if (vector3 == null) {
                    vector3 = new Vector();
                    resourceDefinition.setDefinitionVector(vector3);
                }
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    e = enumeration.nextElement();
                    if (vector3.indexOf(e) != -1) continue;
                    vector3.addElement(e);
                }
                this.processEffectedResourceInstances(vector, string2, true);
            }
            if (vector2 != null) {
                vector3 = resourceDefinition.getViewsVector();
                if (vector3 == null) {
                    vector3 = vector2;
                    resourceDefinition.setViewsVector(vector3);
                } else {
                    enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        e = enumeration.nextElement();
                        if (vector3.indexOf(e) != -1) continue;
                        vector3.addElement(e);
                    }
                }
            }
            if (string != null) {
                vector3 = resourceDefinition.getDeviceTypes();
                if (vector3 == null) {
                    vector3 = new Vector();
                    resourceDefinition.setDeviceTypes(vector3);
                }
                if (vector3.indexOf(string) == -1) {
                    vector3.addElement(string);
                }
            }
            this.resourceDefinitionTable.put(resourceDefinition.getIdentifier(), resourceDefinition);
            bl = true;
        }
        return bl;
    }

    public boolean removeTemplateDefinitionsFromResource(Vector vector, Vector vector2, String string, String string2) throws RemoteException {
        boolean bl = false;
        dpServerImpl.DM("Removing template information from resource");
        ResourceDefinition resourceDefinition = (ResourceDefinition)this.resourceDefinitionTable.get(string2);
        if (resourceDefinition != null) {
            int n;
            Object e;
            Enumeration enumeration;
            Vector vector3;
            if (vector != null) {
                vector3 = resourceDefinition.getDefinitionVector();
                if (vector3 == null) {
                    vector3 = new Vector();
                    resourceDefinition.setDefinitionVector(vector3);
                }
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    e = enumeration.nextElement();
                    n = vector3.indexOf(e);
                    if (n <= -1) continue;
                    vector3.removeElementAt(n);
                }
                this.processEffectedResourceInstances(vector, string2, false);
            }
            if (vector2 != null) {
                vector3 = resourceDefinition.getViewsVector();
                if (vector3 == null) {
                    vector3 = vector2;
                    resourceDefinition.setViewsVector(vector3);
                } else {
                    enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        e = enumeration.nextElement();
                        n = vector3.indexOf(e);
                        if (n <= -1) continue;
                        vector3.removeElementAt(n);
                    }
                }
            }
            this.resourceDefinitionTable.put(resourceDefinition.getIdentifier(), resourceDefinition);
            bl = true;
        }
        return bl;
    }

    public boolean addResourceDefinition(ResourceDefinition resourceDefinition) throws RemoteException {
        boolean bl = false;
        if ((ResourceDefinition)this.resourceDefinitionTable.get(resourceDefinition.getIdentifier()) == null && this.pollingObjectDefinitionsExist(resourceDefinition.getDefinitionVector())) {
            dpServerImpl.DM("Resource : " + resourceDefinition.getIdentifier() + " added.");
            this.resourceDefinitionTable.put(resourceDefinition.getIdentifier(), resourceDefinition);
            bl = true;
        }
        return bl;
    }

    public synchronized boolean removeResourceDefinition(String string) throws RemoteException {
        boolean bl = true;
        ResourceDefinition cfr_ignored_0 = (ResourceDefinition)this.resourceDefinitionTable.get(string);
        Enumeration enumeration = this.pRITable.elements();
        while (enumeration.hasMoreElements() && bl) {
            ResourceInstance resourceInstance = (ResourceInstance)enumeration.nextElement();
            if (!string.equals(resourceInstance.getDefinition().getIdentifier())) continue;
            bl = false;
        }
        if (bl) {
            this.resourceDefinitionTable.remove(string);
        }
        return bl;
    }

    public Vector getResourceDefinitionList() throws RemoteException {
        SortedStringVector sortedStringVector = null;
        Enumeration enumeration = this.resourceDefinitionTable.keys();
        if (enumeration != null) {
            sortedStringVector = new SortedStringVector();
        }
        while (enumeration.hasMoreElements()) {
            sortedStringVector.addString((String)enumeration.nextElement());
        }
        return sortedStringVector;
    }

    public ResourceDefinition getResourceDefinition(String string) throws RemoteException {
        return (ResourceDefinition)this.resourceDefinitionTable.get(string);
    }

    public synchronized boolean removeResourceManager(String string, String string2, DpResourceInstance dpResourceInstance) throws RemoteException {
        DpResourceManagerClass dpResourceManagerClass = new DpResourceManagerClass(string, null, string2, dpResourceInstance);
        return this.clearResourceInstance(dpResourceManagerClass);
    }

    public synchronized long getUniqueKey() {
        long l = (Long)this.generalSettingsTable.get("unique_key");
        this.generalSettingsTable.put("unique_key", new Long(l + 1L));
        return l;
    }

    private void processEffectedResourceInstances(Vector vector, String string, boolean bl) {
        Object object = this.getConfigLock();
        synchronized (object) {
            Vector<Object> vector2 = new Vector<Object>();
            Enumeration enumeration = this.pRITable.elements();
            while (enumeration.hasMoreElements()) {
                ResourceInstance resourceInstance = (ResourceInstance)enumeration.nextElement();
                if (resourceInstance.getDefinition().getIdentifier().equals(string)) {
                    Object object2;
                    Enumeration enumeration2;
                    if (bl) {
                        if (resourceInstance.getPOIs() == null || resourceInstance.getPOIs().size() == 0) {
                            resourceInstance.setManaged(true);
                        }
                        enumeration2 = vector.elements();
                        while (enumeration2.hasMoreElements()) {
                            object2 = new PollingObjectInstance(resourceInstance.getHostname(), resourceInstance.getCommunityName(), (String)enumeration2.nextElement());
                            if (resourceInstance.getTableIndices() != null) {
                                ((PollingObjectInstance)object2).setKeywords(resourceInstance.getTableIndices());
                            }
                            ((PollingObjectInstance)object2).setIndex(this.getUniqueKey());
                            vector2.addElement(object2);
                            resourceInstance.getPOIs().addElement(object2);
                        }
                    } else {
                        enumeration2 = resourceInstance.getPOIs().elements();
                        while (enumeration2.hasMoreElements()) {
                            object2 = (PollingObjectInstance)enumeration2.nextElement();
                            int n = vector.indexOf(((PollingObjectInstance)object2).getIdentifier());
                            if (n <= -1) continue;
                            vector2.addElement(object2);
                        }
                        object2 = vector2.elements();
                        while (object2.hasMoreElements()) {
                            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)object2.nextElement();
                            resourceInstance.getPOIs().removeElement(pollingObjectInstance);
                        }
                        if (resourceInstance.getPOIs() == null || resourceInstance.getPOIs().size() == 0) {
                            resourceInstance.setManaged(false);
                        }
                    }
                }
                this.pRITable.put(PHashtable.createKey(resourceInstance.getHostname(), resourceInstance.getDefinition().getIdentifier(), Long.toString(resourceInstance.getKey())), resourceInstance);
            }
            try {
                if (bl && vector2.size() > 0) {
                    dpServerImpl.DM("dpServerImpl:processEffectedResourceInstances : added pois to : " + string);
                    this.addPollingObjectInstances(vector2, false);
                } else if (!bl && vector2.size() > 0) {
                    dpServerImpl.DM("dpServerImpl:processEffectedResourceInstances : removed pois from : " + string);
                    this.removePollingObjectInstances(vector2, true);
                }
            }
            catch (RemoteException remoteException) {
                dpServerImpl.DM("dpServerImpl:processEffectedResourceInstances", remoteException);
            }
            return;
        }
    }

    public boolean addResourceInstance(DpResourceManager dpResourceManager) throws RemoteException {
        Object object = this.getConfigLock();
        synchronized (object) {
            try {
                String string = InetAddress.getByName(dpResourceManager.dpGetHostname()).getHostAddress();
                ResourceDefinition resourceDefinition = (ResourceDefinition)this.resourceDefinitionTable.get(dpResourceManager.dpGetResourceType());
                if (resourceDefinition == null) {
                    dpResourceManager.dpSetState(new PerformanceEvent(16, dpResourceManager.dpGetHostname(), dpResourceManager.dpGetResourceType(), null, 0L, 0L));
                } else {
                    PollingObjectInstance pollingObjectInstance;
                    Object object2;
                    Object object3;
                    Serializable serializable;
                    boolean bl = false;
                    Enumeration enumeration = this.resourceInstanceTable.getElements(string, dpResourceManager.dpGetResourceType());
                    while (enumeration != null && enumeration.hasMoreElements()) {
                        serializable = (ResourceInstance)enumeration.nextElement();
                        if (!HashtableUtil.compareTwoHashtables(((ResourceInstance)serializable).getTableIndices(), dpResourceManager.dpGetResourceInstance())) continue;
                        dpServerImpl.DM("Updating current DpResourceManager.");
                        ((ResourceInstance)serializable).setDpResourceManager(dpResourceManager);
                        object3 = new Integer(35);
                        object2 = this.theEventRegistry.getEvents(new EventFilter((Integer)object3, dpResourceManager.dpGetResourceType(), string, 2));
                        if (object2 != null && ((Vector)object2).size() > 0) {
                            pollingObjectInstance = (PerformanceEvent)((Vector)object2).lastElement();
                            dpResourceManager.dpSetState((DpResourceState)((Object)pollingObjectInstance));
                        } else {
                            dpResourceManager.dpSetState(new PerformanceEvent(2, dpResourceManager.dpGetHostname(), dpResourceManager.dpGetResourceType(), null, 0L, 0L));
                        }
                        bl = true;
                    }
                    if (!bl) {
                        serializable = new Vector();
                        if (resourceDefinition.getDefinitionVector() != null && dpResourceManager != null) {
                            object3 = resourceDefinition.getDefinitionVector().elements();
                            while (object3.hasMoreElements()) {
                                object2 = (String)object3.nextElement();
                                pollingObjectInstance = new PollingObjectInstance(string, dpResourceManager.dpGetCommunityName(), (String)object2);
                                if (dpResourceManager != null && dpResourceManager.dpGetResourceInstance() != null) {
                                    pollingObjectInstance.setKeywords((Hashtable)dpResourceManager.dpGetResourceInstance().clone());
                                }
                                ((Vector)serializable).addElement(pollingObjectInstance);
                            }
                            if (((Vector)serializable).size() > 0) {
                                object2 = this.addPollingObjectInstances((Vector)serializable);
                                long l = this.getUniqueKey();
                                ResourceInstance resourceInstance = new ResourceInstance(string, resourceDefinition, dpResourceManager, l, dpResourceManager.dpGetCommunityName());
                                resourceInstance.setPOIs((Vector)object2);
                                this.resourceInstanceTable.put(string, dpResourceManager.dpGetResourceType(), new Long(l), resourceInstance);
                                this.pRITable.put(PHashtable.createKey(string, dpResourceManager.dpGetResourceType(), Long.toString(l)), resourceInstance);
                                dpResourceManager.dpSetState(new PerformanceEvent(2, dpResourceManager.dpGetHostname(), dpResourceManager.dpGetResourceType(), null, 0L, 0L));
                            } else {
                                dpResourceManager.dpSetState(new PerformanceEvent(16, dpResourceManager.dpGetHostname(), dpResourceManager.dpGetResourceType(), null, 0L, 0L));
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                dpServerImpl.DM("dpServerImpl:addResourceInstance", exception);
            }
        }
        return true;
    }

    private void dumpResourceInstanceTable() {
        Enumeration enumeration = this.pRITable.elements();
        while (enumeration.hasMoreElements()) {
            ResourceInstance resourceInstance = (ResourceInstance)enumeration.nextElement();
            resourceInstance.toString();
        }
    }

    public Vector addPollingObjectInstances(Vector vector) throws RemoteException {
        return this.addPollingObjectInstances(vector, true, null);
    }

    public Vector addPollingObjectInstances(Vector vector, boolean bl) throws RemoteException {
        return this.addPollingObjectInstances(vector, bl, null);
    }

    public Vector addPollingObjectInstances(Vector vector, boolean bl, OrdinalRangeVector ordinalRangeVector) {
        Object object = this.getConfigLock();
        synchronized (object) {
            try {
                Vector<Vector<PollingObjectInstance>> vector2;
                Vector<PollingObjectInstance> vector3;
                long l = System.currentTimeMillis();
                Hashtable hashtable = new Hashtable();
                Hashtable<String, Vector<PollingObjectInstance>> hashtable2 = new Hashtable<String, Vector<PollingObjectInstance>>();
                Vector vector4 = new Vector();
                Vector<PollingObjectInstance> vector5 = new Vector<PollingObjectInstance>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
                    pollingObjectInstance.setHostname(InetAddress.getByName(pollingObjectInstance.getHostname()).getHostAddress());
                    String string = null;
                    if (ordinalRangeVector != null) {
                        vector3 = ordinalRangeVector.lookup(IPAddress.toLong(pollingObjectInstance.getHostname()));
                        string = ((DPERange)((Object)vector3)).getDPEAddress();
                    } else {
                        string = this.theDPEDirectory.lookup(pollingObjectInstance.getHostname());
                    }
                    if (vector4.indexOf(pollingObjectInstance.getIdentifier()) == -1) {
                        vector3 = null;
                        if (pollingObjectInstance.getIdentifier() != null) {
                            vector3 = (PollingObjectDefinition)this.pollingDefinitionTable.get(pollingObjectInstance.getIdentifier());
                        }
                        if ((vector2 = (Vector)hashtable.get(string)) == null) {
                            vector2 = new Vector<Vector<PollingObjectInstance>>();
                            hashtable.put(string, vector2);
                        }
                        if (!vector2.contains(vector3)) {
                            vector2.addElement(vector3);
                        }
                    }
                    if (ordinalRangeVector == null) {
                        if (bl) {
                            pollingObjectInstance.setIndex(this.getUniqueKey());
                        }
                        this.pollingInstanceTable.put(pollingObjectInstance.getHostname(), pollingObjectInstance.getIdentifier(), pollingObjectInstance.getLongIndex(), pollingObjectInstance);
                        this.pPOITable.put(pollingObjectInstance, pollingObjectInstance);
                    }
                    if ((vector3 = (Vector)hashtable2.get(string)) == null) {
                        vector3 = new Vector<PollingObjectInstance>();
                        hashtable2.put(string, vector3);
                    }
                    vector3.addElement(pollingObjectInstance);
                    vector5.addElement(pollingObjectInstance);
                }
                long l2 = System.currentTimeMillis();
                vector3 = null;
                vector3 = new DpeWorkerManager();
                vector2 = hashtable2.keys();
                while (vector2.hasMoreElements()) {
                    try {
                        String string = (String)vector2.nextElement();
                        Vector vector6 = (Vector)hashtable.get(string);
                        Vector vector7 = (Vector)hashtable2.get(string);
                        DpInterface dpInterface = (DpInterface)this.dpeTable.get(string);
                        if (vector3 != null) {
                            if (vector6 != null) {
                                ((DpeWorkerManager)((Object)vector3)).addWork(dpInterface, vector6, 4);
                            } else {
                                dpServerImpl.DM("DEF VECTOR WAS NULL");
                            }
                            ((DpeWorkerManager)((Object)vector3)).addWork(dpInterface, vector7, 1);
                            continue;
                        }
                        if (vector6 != null) {
                            dpInterface.addPollingObjectDefinitions(vector6);
                        }
                        dpInterface.addPollingObjectInstances(vector7);
                    }
                    catch (RemoteException remoteException) {
                        Traces.logException(remoteException);
                    }
                }
                if (vector3 != null) {
                    ((DpeWorkerManager)((Object)vector3)).startAndReturn();
                }
                long l3 = System.currentTimeMillis();
                dpServerImpl.DM("Add PODs and POIs took : " + (l3 - l2) + " ms , Loop time: " + (l2 - l) + " ms");
                Vector<PollingObjectInstance> vector8 = vector5;
                Object var6_24 = null;
                return vector8;
            }
            catch (Exception exception) {
                dpServerImpl.DM("dpServerImpl:addPollingObjectInstances:exception occurred", exception);
            }
        }
        return null;
    }

    private boolean partOfResourceInstance(PollingObjectInstance pollingObjectInstance) {
        boolean bl = false;
        Enumeration enumeration = this.resourceInstanceTable.get(pollingObjectInstance.getHostname());
        block0: while (enumeration != null && enumeration.hasMoreElements() && !bl) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = this.resourceInstanceTable.get(pollingObjectInstance.getHostname(), string);
            while (enumeration2.hasMoreElements() && !bl) {
                ResourceInstance resourceInstance = (ResourceInstance)enumeration2.nextElement();
                Vector vector = resourceInstance.getDefinition().getDefinitionVector();
                if (vector == null || vector.indexOf(string) == -1) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public boolean removePollingObjectInstances(Vector vector, boolean bl) throws RemoteException {
        return this.removePollingObjectInstances(vector, bl, true, null);
    }

    public boolean removePollingObjectInstances(Vector vector, boolean bl, boolean bl2) throws RemoteException {
        return this.removePollingObjectInstances(vector, bl, bl2, null);
    }

    private boolean removePollingObjectInstances(Vector vector, boolean bl, boolean bl2, OrdinalRangeVector ordinalRangeVector) {
        Object object = this.getConfigLock();
        synchronized (object) {
            try {
                Vector<PollingObjectInstance> vector2;
                Object object2;
                Hashtable<Object, Vector<PollingObjectInstance>> hashtable = new Hashtable<Object, Vector<PollingObjectInstance>>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
                    String string = pollingObjectInstance.getHostname();
                    string = InetAddress.getByName(string).getHostAddress();
                    pollingObjectInstance.setHostname(string);
                    if (!bl && this.partOfResourceInstance(pollingObjectInstance)) continue;
                    if (bl2) {
                        this.pollingInstanceTable.remove(string, pollingObjectInstance.getIdentifier(), pollingObjectInstance.getLongIndex());
                        this.pPOITable.remove(pollingObjectInstance);
                    }
                    object2 = null;
                    if (ordinalRangeVector != null) {
                        vector2 = ordinalRangeVector.lookup(IPAddress.toLong(pollingObjectInstance.getHostname()));
                        object2 = ((DPERange)((Object)vector2)).getDPEAddress();
                    } else {
                        object2 = this.theDPEDirectory.lookup(pollingObjectInstance.getHostname());
                    }
                    vector2 = (Vector)hashtable.get(object2);
                    if (vector2 == null) {
                        vector2 = new Vector<PollingObjectInstance>();
                        hashtable.put(object2, vector2);
                    }
                    vector2.addElement(pollingObjectInstance);
                }
                long l = System.currentTimeMillis();
                object2 = null;
                object2 = new DpeWorkerManager();
                vector2 = hashtable.keys();
                while (vector2.hasMoreElements()) {
                    try {
                        String string = (String)vector2.nextElement();
                        DpInterface dpInterface = (DpInterface)this.dpeTable.get(string);
                        Vector vector3 = (Vector)hashtable.get(string);
                        dpServerImpl.DM("Removing..." + vector3.size() + " instances from " + string);
                        if (object2 != null) {
                            ((DpeWorkerManager)object2).addWork(dpInterface, vector3, 2);
                            continue;
                        }
                        dpInterface.removePollingObjectInstances(vector3);
                    }
                    catch (RemoteException remoteException) {
                        Traces.logException(remoteException);
                    }
                }
                if (object2 != null) {
                    ((DpeWorkerManager)object2).startAndReturn();
                }
                dpServerImpl.DM("Removing PollingObjectInstances took: " + (System.currentTimeMillis() - l) + " ms ");
                boolean bl3 = true;
                Object var7_19 = null;
                return bl3;
            }
            catch (Exception exception) {
                dpServerImpl.DM("dpServerImpl:removePollingObjectInstances:exception occured", exception);
            }
        }
        return false;
    }

    private boolean podExistOnDPE(String string, String string2) {
        long l;
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        try {
            Enumeration enumeration = this.pollingInstanceTable.keys();
            while (enumeration.hasMoreElements() && !bl) {
                Enumeration enumeration2;
                String string3 = (String)enumeration.nextElement();
                String string4 = this.theDPEDirectory.lookup(string3);
                if (!string4.equals(string2) || (enumeration2 = this.pollingInstanceTable.get(string3, string)) == null || !enumeration2.hasMoreElements()) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:podExistsOnDPE:exception", exception);
            exception.printStackTrace();
        }
        if ((l = System.currentTimeMillis() - l2) > 100L) {
            dpServerImpl.DM("POD EXIST ON DPE TOOK: " + l + " ms ");
        }
        return bl;
    }

    public boolean clearResourceInstance(DpResourceManager dpResourceManager) throws RemoteException {
        boolean bl = false;
        Object object = this.getConfigLock();
        synchronized (object) {
            String string = dpResourceManager.dpGetHostname();
            try {
                string = InetAddress.getByName(string).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {}
            String string2 = dpResourceManager.dpGetResourceType();
            Enumeration enumeration = this.resourceInstanceTable.getElements(string, string2);
            while (enumeration != null && enumeration.hasMoreElements()) {
                ResourceInstance resourceInstance = (ResourceInstance)enumeration.nextElement();
                if (resourceInstance == null || !HashtableUtil.compareTwoHashtables(resourceInstance.getTableIndices(), dpResourceManager.dpGetResourceInstance())) continue;
                resourceInstance.setDpResourceManager(null);
                dpServerImpl.DM("DpResourceManager cleared for " + string + "/" + string2);
                bl = true;
            }
            if (!bl) {
                dpServerImpl.DM("Did not find the DpResourceManager you requested");
            }
        }
        return bl;
    }

    public boolean unManageNode(String string) throws RemoteException {
        Enumeration enumeration = this.resourceInstanceTable.get(string);
        boolean bl = false;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Enumeration enumeration2 = this.resourceInstanceTable.getElements(string, string2);
                if (enumeration2 == null) continue;
                while (enumeration2.hasMoreElements()) {
                    ResourceInstance resourceInstance = (ResourceInstance)enumeration2.nextElement();
                    DpResourceManagerClass dpResourceManagerClass = new DpResourceManagerClass(resourceInstance.getHostname(), null, resourceInstance.getDefinition().getIdentifier(), resourceInstance.getTableIndices());
                    this.removeResourceInstance(dpResourceManagerClass);
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean removeResourceInstance(DpResourceManager dpResourceManager) throws RemoteException {
        boolean bl = false;
        Object object = this.getConfigLock();
        synchronized (object) {
            ResourceInstance resourceInstance = this.getResourceInstance(dpResourceManager);
            if (resourceInstance != null) {
                this.removePollingObjectInstances(resourceInstance.getPOIs(), true);
                this.resourceInstanceTable.remove(resourceInstance.getHostname(), resourceInstance.getDefinition().getIdentifier(), new Long(resourceInstance.getKey()));
                this.pRITable.remove(PHashtable.createKey(resourceInstance.getHostname(), resourceInstance.getDefinition().getIdentifier(), Long.toString(resourceInstance.getKey())));
                resourceInstance.setState(new PerformanceEvent(16, dpResourceManager.dpGetHostname(), dpResourceManager.dpGetResourceType(), null, 0L, 0L));
                bl = true;
            }
        }
        return bl;
    }

    public Vector getResourceNodeList() throws RemoteException {
        SortedStringVector sortedStringVector = null;
        Enumeration enumeration = this.resourceInstanceTable.keys();
        if (enumeration != null) {
            sortedStringVector = new SortedStringVector();
        }
        while (enumeration.hasMoreElements()) {
            sortedStringVector.addString((String)enumeration.nextElement());
        }
        return sortedStringVector;
    }

    public Vector getPollingResourceIdentifiers(String string) throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        Enumeration enumeration = this.resourceDefinitionTable.elements();
        while (enumeration.hasMoreElements()) {
            ResourceDefinition resourceDefinition = (ResourceDefinition)enumeration.nextElement();
            if (resourceDefinition.getDefinitionVector() == null || resourceDefinition.getDefinitionVector().indexOf(string) == -1) continue;
            sortedStringVector.addString(resourceDefinition.getIdentifier());
        }
        if (sortedStringVector.size() > 0) {
            return sortedStringVector;
        }
        return null;
    }

    public Vector getResourceInstances(PollingObjectInstance pollingObjectInstance) {
        Vector<ResourceInstance> vector = new Vector<ResourceInstance>();
        Enumeration enumeration = this.resourceInstanceTable.get(pollingObjectInstance.getHostname());
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Enumeration enumeration2 = this.resourceInstanceTable.getElements(pollingObjectInstance.getHostname(), string);
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                ResourceInstance resourceInstance = (ResourceInstance)enumeration2.nextElement();
                if (resourceInstance.getPOIs() == null || resourceInstance.getPOIs().indexOf(pollingObjectInstance) == -1) continue;
                vector.addElement(resourceInstance);
            }
        }
        return vector;
    }

    public ResourceInstance getResourceInstance(String string, String string2) throws RemoteException {
        DpResourceManagerClass dpResourceManagerClass = new DpResourceManagerClass(string2, null, string, null);
        return this.getResourceInstance(dpResourceManagerClass);
    }

    public ResourceInstance getResourceInstance(DpResourceManager dpResourceManager) throws RemoteException {
        String string = null;
        try {
            string = InetAddress.getByName(dpResourceManager.dpGetHostname()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            dpServerImpl.DM("dpServerImpl:getResourceInstance", unknownHostException);
        }
        Enumeration enumeration = this.resourceInstanceTable.getElements(string, dpResourceManager.dpGetResourceType());
        boolean bl = false;
        ResourceInstance resourceInstance = null;
        while (enumeration != null && enumeration.hasMoreElements() && !bl) {
            ResourceInstance resourceInstance2 = (ResourceInstance)enumeration.nextElement();
            if (!HashtableUtil.compareTwoHashtables(resourceInstance2.getTableIndices(), dpResourceManager.dpGetResourceInstance())) continue;
            resourceInstance = resourceInstance2;
            bl = true;
        }
        if (!bl) {
            dpServerImpl.DM(String.valueOf(dpResourceManager.dpGetResourceType()) + "/" + string + " is an invalid resource instance");
        }
        return resourceInstance;
    }

    public boolean addPollingObjectDefinition(PollingObjectDefinition pollingObjectDefinition) throws RemoteException {
        dpServerImpl.DM("Adding PollingObjectDefinition: " + pollingObjectDefinition.getIdentifier());
        boolean bl = false;
        PollingObjectDefinition pollingObjectDefinition2 = null;
        Object object = this.getConfigLock();
        synchronized (object) {
            pollingObjectDefinition2 = (PollingObjectDefinition)this.resourceDefinitionTable.get(pollingObjectDefinition.getIdentifier());
            if (pollingObjectDefinition2 == null || pollingObjectDefinition.getExpression().compareTo(pollingObjectDefinition2.getExpression()) != 0) {
                this.pollingDefinitionTable.put(pollingObjectDefinition.getIdentifier(), pollingObjectDefinition);
                bl = true;
            }
        }
        return bl;
    }

    public boolean modifyPollingObjectDefinition(String string, NotifyObject notifyObject) throws RemoteException {
        boolean bl = true;
        Object object = this.getConfigLock();
        synchronized (object) {
            PollingObjectDefinition pollingObjectDefinition = (PollingObjectDefinition)this.pollingDefinitionTable.get(string);
            Enumeration enumeration = this.dpeTable.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    String string2 = (String)enumeration.nextElement();
                    if (!this.podExistOnDPE(string, string2)) continue;
                    DpInterface dpInterface = (DpInterface)this.dpeTable.get(string2);
                    dpInterface.modifyPollingObjectDefinition(string, notifyObject);
                }
                catch (RemoteException remoteException) {
                    Traces.logException(remoteException);
                }
            }
            pollingObjectDefinition.setNotifyObject(notifyObject);
            this.pollingDefinitionTable.put(string, pollingObjectDefinition);
        }
        return bl;
    }

    public String removePollingObjectDefinition(String string) throws RemoteException {
        String string2 = null;
        Object object = this.getConfigLock();
        synchronized (object) {
            PollingObjectDefinition pollingObjectDefinition = (PollingObjectDefinition)this.pollingDefinitionTable.get(string);
            if (pollingObjectDefinition != null) {
                string2 = this.partOfResourceDefinition(string);
                if (string2 == null) {
                    string2 = this.partOfGraphDefinition(string);
                }
            } else {
                string2 = new String(string);
            }
            if (string2 == null) {
                this.pollingDefinitionTable.remove(string);
            }
        }
        return string2;
    }

    private String partOfResourceDefinition(String string) {
        String string2 = null;
        Enumeration enumeration = this.resourceDefinitionTable.elements();
        while (enumeration != null && enumeration.hasMoreElements() && string2 == null) {
            ResourceDefinition resourceDefinition = (ResourceDefinition)enumeration.nextElement();
            if (resourceDefinition.getDefinitionVector().indexOf(string) == -1) continue;
            string2 = resourceDefinition.getIdentifier();
        }
        return string2;
    }

    private String partOfGraphDefinition(String string) {
        String string2 = null;
        Enumeration enumeration = this.graphDefinitionTable.elements();
        while (enumeration != null && enumeration.hasMoreElements() && string2 == null) {
            GraphDefinition graphDefinition = (GraphDefinition)enumeration.nextElement();
            if (graphDefinition.getPollingObjects().get(string) == null) continue;
            string2 = graphDefinition.getGraphName();
        }
        return string2;
    }

    public PollingObjectDefinition getPollingDefinition(String string) throws RemoteException {
        return (PollingObjectDefinition)this.pollingDefinitionTable.get(string);
    }

    public Vector getPollingObjectDefinitionList() throws RemoteException {
        SortedStringVector sortedStringVector = null;
        Enumeration enumeration = this.pollingDefinitionTable.keys();
        if (enumeration != null) {
            sortedStringVector = new SortedStringVector();
        }
        while (enumeration.hasMoreElements()) {
            sortedStringVector.addString((String)enumeration.nextElement());
        }
        return sortedStringVector;
    }

    public Vector getPOIList(String string) {
        Vector vector = null;
        Enumeration enumeration = this.pollingInstanceTable.get(string);
        if (enumeration != null) {
            vector = new Vector();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Enumeration enumeration2 = this.pollingInstanceTable.getElements(string, string2);
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    vector.addElement(enumeration2.nextElement());
                }
            }
        } else {
            dpServerImpl.DM("dpServerImpl:getPOIList : pollingInstanceTable was null");
        }
        return vector;
    }

    public Vector getPollingObjectDefinitionList(String string) throws RemoteException {
        Vector vector = null;
        Enumeration enumeration = this.pollingInstanceTable.get(string);
        if (enumeration != null) {
            vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        } else {
            dpServerImpl.DM("dpServerImpl:getPOIList : pollingInstanceTable was null");
        }
        return vector;
    }

    public Vector getPollingNodeList() throws RemoteException {
        SortedStringVector sortedStringVector = null;
        Enumeration enumeration = this.pollingInstanceTable.keys();
        if (enumeration != null && enumeration.hasMoreElements()) {
            sortedStringVector = new SortedStringVector();
        }
        while (enumeration.hasMoreElements()) {
            sortedStringVector.addString((String)enumeration.nextElement());
        }
        return sortedStringVector;
    }

    public Vector getPollingObjectIndices(String string, String string2) throws RemoteException {
        Vector vector = null;
        try {
            Vector vector2;
            string2 = InetAddress.getByName(string2).getHostAddress();
            String string3 = this.theDPEDirectory.lookup(string2);
            DpInterface dpInterface = (DpInterface)this.dpeTable.get(string3);
            Enumeration enumeration = this.pollingInstanceTable.getElements(string2, string);
            Vector vector3 = new Vector();
            while (enumeration != null && enumeration.hasMoreElements()) {
                vector2 = dpInterface.getPollingObjectInstanceIndices((PollingObjectInstance)enumeration.nextElement());
                vector3 = VectorUtil.unionOfTwoVectors(vector3, vector2);
            }
            vector2 = null;
            if (this.connectedToDatabase()) {
                vector2 = this.theDatabaseConnection.getPollingObjectInstanceIndices(string, string2);
            }
            if ((vector = VectorUtil.unionOfTwoVectors(vector3, vector2)) == null || vector != null && vector.size() <= 1) {
                dpServerImpl.DM("dpServerImpl:getPollingObjectIndicies: no indicies were found");
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getPollingObjectIndicies: exception occurred", exception);
        }
        return vector;
    }

    public PollingObjectInstance getPollingObjectInstance(String string, String string2) throws RemoteException {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string);
        Vector vector2 = this.getPollingObjectInstances(vector, string2);
        return (PollingObjectInstance)vector2.firstElement();
    }

    public PollingObjectInstance getPollingObjectInstance(String string, String string2, long l, long l2) throws RemoteException {
        Vector vector = this.getPollingObjectInstances(string, string2, null, l, l2);
        return (PollingObjectInstance)vector.firstElement();
    }

    public Vector getPollingObjectInstances(String string, String string2, Vector vector) throws RemoteException {
        long l = System.currentTimeMillis();
        return this.getPollingObjectInstances(string, string2, vector, l - 0x6DDD00L, l);
    }

    public Vector getPollingObjectInstances(Vector vector, String string) throws RemoteException {
        return this.getPollingObjectInstances(vector, string, null, System.currentTimeMillis() - 0x6DDD00L, System.currentTimeMillis());
    }

    public Vector getPollingObjectInstances(Vector vector, String string, Vector vector2, long l, long l2) throws RemoteException {
        Vector vector3 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector4 = this.getPollingObjectInstances((String)enumeration.nextElement(), string, vector2, l, l2);
            if (vector4 == null) continue;
            Enumeration enumeration2 = vector4.elements();
            while (enumeration2.hasMoreElements()) {
                vector3.addElement(enumeration2.nextElement());
            }
        }
        if (vector3.size() == 0) {
            vector3 = null;
        }
        return vector3;
    }

    public PollingObjectInstance getPollingObjectInstance(String string, String string2, DpResourceInstance dpResourceInstance) {
        PollingObjectInstance pollingObjectInstance = null;
        boolean bl = false;
        Enumeration enumeration = this.pollingInstanceTable.getElements(string2, string);
        while (enumeration != null && enumeration.hasMoreElements() && !bl) {
            PollingObjectInstance pollingObjectInstance2 = (PollingObjectInstance)enumeration.nextElement();
            if (!HashtableUtil.compareTwoHashtables(dpResourceInstance, pollingObjectInstance2.getKeywords())) continue;
            pollingObjectInstance = pollingObjectInstance2;
            bl = true;
        }
        return pollingObjectInstance;
    }

    public Vector getPollingObjectInstances(String string, String string2, Vector vector, long l, long l2) {
        Vector vector2 = null;
        try {
            string2 = InetAddress.getByName(string2).getHostAddress();
            String string3 = this.theDPEDirectory.lookup(string2);
            DpInterface dpInterface = (DpInterface)this.dpeTable.get(string3);
            vector2 = new Vector();
            Enumeration enumeration = this.pollingInstanceTable.getElements(string2, string);
            Vector vector3 = new Vector();
            while (enumeration != null && enumeration.hasMoreElements()) {
                vector3.addElement(enumeration.nextElement());
            }
            Vector vector4 = dpInterface.getPollingObjectInstance(vector3, vector, l);
            if (this.connectedToDatabase()) {
                Hashtable hashtable = this.theDatabaseConnection.getHistory((PollingObjectInstance)vector3.firstElement(), l, l2, vector);
                Hashtable hashtable2 = SeparatorUtil.separateData(hashtable, vector4, l, l2);
                vector2 = SeparatorUtil.getPOIVectors(hashtable2);
            }
            if ((vector2 == null || vector2.size() == 0) && vector4 != null) {
                vector2 = SeparatorUtil.getPOIVectors(SeparatorUtil.separateData(null, vector4, l, l2));
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getPollingObjectInstances", exception);
        }
        if (vector2 != null && vector2.size() == 0) {
            vector2 = null;
        }
        return vector2;
    }

    public synchronized boolean modifyPollingObjectInstance(PollingObjectInstance pollingObjectInstance, NotifyObject notifyObject) throws RemoteException {
        boolean bl = false;
        try {
            String string = InetAddress.getByName(pollingObjectInstance.getHostname()).getHostAddress();
            Enumeration enumeration = null;
            Object object = this.getConfigLock();
            synchronized (object) {
                Object object2;
                Serializable serializable;
                if (pollingObjectInstance.getIndex() > -1L) {
                    serializable = new Vector<PollingObjectInstance>();
                    object2 = (PollingObjectInstance)this.pollingInstanceTable.get(string, pollingObjectInstance.getIdentifier(), pollingObjectInstance.getLongIndex());
                    if (object2 != null) {
                        ((Vector)serializable).addElement(object2);
                    }
                    enumeration = ((Vector)serializable).elements();
                } else {
                    enumeration = this.pollingInstanceTable.get(string, pollingObjectInstance.getIdentifier());
                }
                while (enumeration != null && enumeration.hasMoreElements()) {
                    serializable = (PollingObjectInstance)enumeration.nextElement();
                    object2 = this.theDPEDirectory.lookup(string);
                    DpInterface dpInterface = (DpInterface)this.dpeTable.get(object2);
                    bl = dpInterface.modifyPollingObjectInstance((PollingObjectInstance)serializable, notifyObject);
                    ((PollingObjectInstance)serializable).setNotifyObject(notifyObject);
                    this.pPOITable.put(serializable, serializable);
                }
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:modifyPollingObjectInstance:exception occurred", exception);
        }
        return bl;
    }

    public void clearDPManager() throws RemoteException {
        dpServerImpl dpServerImpl2 = this;
        synchronized (dpServerImpl2) {
            try {
                Object object;
                Object object2;
                Enumeration enumeration = this.pRITable.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (ResourceInstance)enumeration.nextElement();
                    object = new DpResourceManagerClass(((ResourceInstance)object2).getHostname(), null, ((ResourceInstance)object2).getDefinition().getIdentifier(), ((ResourceInstance)object2).getTableIndices());
                    this.removeResourceInstance((DpResourceManager)object);
                }
                object2 = this.resourceDefinitionTable.elements();
                while (object2.hasMoreElements()) {
                    object = (ResourceDefinition)object2.nextElement();
                    dpServerImpl.DM("removing : res def " + ((ResourceDefinition)object).getIdentifier());
                    this.removeResourceDefinition(((ResourceDefinition)object).getIdentifier());
                }
                object = this.pollingDefinitionTable.elements();
                while (object.hasMoreElements()) {
                    PollingObjectDefinition pollingObjectDefinition = (PollingObjectDefinition)object.nextElement();
                    dpServerImpl.DM("removing : pol def " + pollingObjectDefinition.getIdentifier());
                    this.removePollingObjectDefinition(pollingObjectDefinition.getIdentifier());
                }
            }
            catch (Exception exception) {
                dpServerImpl.DM("dpServerImpl:clearDPManager:exception occurred", exception);
            }
            return;
        }
    }

    public void dumpDPE(String string) throws RemoteException {
        try {
            DpInterface dpInterface = (DpInterface)this.dpeTable.get(InetAddress.getByName(string).getHostAddress());
            dpInterface.dumpDpInterface();
            return;
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:dumpDPE", exception);
            return;
        }
    }

    public Vector getAssignedDPEs() throws RemoteException {
        return this.getAssignedDPEs(true);
    }

    public Vector getAssignedDPEs(boolean bl) throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        try {
            Enumeration enumeration = this.theDPEDirectory.getDPEList().elements();
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    sortedStringVector.addString(InetAddress.getByName((String)enumeration.nextElement()).getHostName());
                    continue;
                }
                sortedStringVector.addString(InetAddress.getByName((String)enumeration.nextElement()).getHostAddress());
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getAssignedDPEs:exception occurred", exception);
        }
        return sortedStringVector;
    }

    public Vector getUnAssignedDPEs() throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        Vector vector = this.getAssignedDPEs(false);
        try {
            Enumeration enumeration = this.dpeTable.elements();
            while (enumeration.hasMoreElements()) {
                DpInterface dpInterface = (DpInterface)enumeration.nextElement();
                if (dpInterface == null || vector.indexOf(dpInterface.getHostname().getHostAddress()) != -1) continue;
                sortedStringVector.addString(dpInterface.getHostname().getHostName());
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getUnAssignedDPEs:exception occurred", exception);
        }
        return sortedStringVector;
    }

    public Vector getNodesPolled(String string) throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostAddress();
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getNodesPolled:exception occurred", exception);
        }
        Enumeration enumeration = this.pPOITable.elements();
        while (enumeration.hasMoreElements()) {
            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
            String string3 = pollingObjectInstance.getHostname();
            String string4 = null;
            try {
                string4 = this.theDPEDirectory.lookup(string3);
            }
            catch (UnknownHostException unknownHostException) {
                dpServerImpl.DM("", unknownHostException);
            }
            if (!string4.equals(string2) || sortedStringVector.indexOf(string3) != -1) continue;
            sortedStringVector.addString(string3);
        }
        return sortedStringVector;
    }

    public SingleNodeResourceAnalysis analyzeResource(String string, String string2, Vector vector, long l, long l2) throws RemoteException {
        if (statAnalyzer == null) {
            statAnalyzer = new StatisticalAnalyzer(this, this.theEventRegistry);
        }
        return statAnalyzer.performSingleNodeAnalysis(string, string2, vector, l, l2);
    }

    public MultipleNodePOAnalysis analyzePollingObject(String[] stringArray, String string, Vector[] vectorArray, long l, long l2) throws RemoteException {
        if (statAnalyzer == null) {
            statAnalyzer = new StatisticalAnalyzer(this, this.theEventRegistry);
        }
        return statAnalyzer.performMultipleNodeAnalysis(stringArray, string, vectorArray, l, l2);
    }

    public ThresholdAnalysis evaluateThresholds(String string, String string2, String string3, long l, long l2) {
        if (statAnalyzer == null) {
            statAnalyzer = new StatisticalAnalyzer(this, this.theEventRegistry);
        }
        return statAnalyzer.evaluateThresholds(string, string2, string3, l, l2);
    }

    public Vector getConnectedDPEs() throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        try {
            Enumeration enumeration = this.dpeTable.elements();
            while (enumeration.hasMoreElements()) {
                DpInterface dpInterface = (DpInterface)enumeration.nextElement();
                if (dpInterface == null) continue;
                sortedStringVector.addString(dpInterface.getHostname().getHostName());
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getConnectedDPEs:exception occurred", exception);
        }
        return sortedStringVector;
    }

    public Vector getActiveDPEs() throws RemoteException {
        SortedStringVector sortedStringVector = new SortedStringVector();
        try {
            Enumeration enumeration = this.theDPEDirectory.getDPEList().elements();
            while (enumeration.hasMoreElements()) {
                sortedStringVector.addString(InetAddress.getByName((String)enumeration.nextElement()).getHostName());
            }
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getActiveDPEs:exception occurred", exception);
        }
        return sortedStringVector;
    }

    public Vector getDPERanges() throws RemoteException {
        return this.theDPEDirectory.getDPERanges();
    }

    public String dumpNodeList() throws RemoteException {
        return String.valueOf(this.dumpPollingDefinitionList()) + this.dumpResourceDefinitionList() + this.dumpResourceInstanceList() + this.dumpEvents() + this.dumpPersistence();
    }

    public String dumpPersistence() {
        String string = new String();
        string = String.valueOf(string) + this.pPOITable.dumpStats();
        string = String.valueOf(string) + this.pRITable.dumpStats();
        return string;
    }

    public String dumpPollingDefinitionList() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.pollingDefinitionTable.elements();
        while (enumeration.hasMoreElements()) {
            PollingObjectDefinition pollingObjectDefinition = (PollingObjectDefinition)enumeration.nextElement();
            stringBuffer.append(String.valueOf(pollingObjectDefinition.toString()) + "\n");
        }
        return stringBuffer.toString();
    }

    public String dumpEvents() {
        EventFilter eventFilter = new EventFilter(new Integer(3), null, null);
        Vector vector = this.theEventRegistry.getEvents(eventFilter);
        StringBuffer stringBuffer = new StringBuffer("\n");
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                PerformanceEvent performanceEvent = (PerformanceEvent)enumeration.nextElement();
                stringBuffer.append(String.valueOf(performanceEvent.toString()) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String dumpResourceDefinitionList() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.resourceDefinitionTable.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2;
            ResourceDefinition resourceDefinition = (ResourceDefinition)enumeration.nextElement();
            stringBuffer.append("Resource ID:  " + resourceDefinition.getIdentifier() + "\n");
            if (resourceDefinition.getViewsVector() != null) {
                enumeration2 = resourceDefinition.getViewsVector().elements();
                while (enumeration2.hasMoreElements()) {
                    stringBuffer.append("--View> " + (String)enumeration2.nextElement() + "\n");
                }
            }
            if (resourceDefinition.getDefinitionVector() != null) {
                enumeration2 = resourceDefinition.getDefinitionVector().elements();
                while (enumeration2.hasMoreElements()) {
                    stringBuffer.append("---POD> " + (String)enumeration2.nextElement() + "\n");
                }
                continue;
            }
            stringBuffer.append("------>NULL\n");
        }
        return stringBuffer.toString();
    }

    public String dumpResourceInstanceList() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.pRITable.keys();
        stringBuffer.append("\nDUMPING RESOURCE INSTANCES:\n\n");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(String.valueOf(string.toString()) + ":");
            if (((ResourceInstance)this.pRITable.get(string)).getIsArmed()) {
                stringBuffer.append("ARMED\n");
                continue;
            }
            stringBuffer.append("REARMED\n");
        }
        return stringBuffer.toString();
    }

    public void clearEvents(Vector vector) throws RemoteException {
        this.theEventRegistry.clearEvents(vector);
    }

    public Vector getEvents(EventFilter eventFilter) throws RemoteException {
        return this.theEventRegistry.getEvents(eventFilter);
    }

    public void registerForEvents(AppletNotifyInterface appletNotifyInterface) throws RemoteException {
        this.theEventRegistry.addListener(appletNotifyInterface);
    }

    public void registerForEvents(AppletNotifyInterface appletNotifyInterface, EventFilter eventFilter) throws RemoteException {
        this.theEventRegistry.addListener(appletNotifyInterface, eventFilter);
    }

    public void shutdownDPE(String string) throws RemoteException {
        try {
            DpInterface dpInterface = (DpInterface)this.dpeTable.get(InetAddress.getByName(string).getHostAddress());
            this.dpeTable.remove(InetAddress.getByName(string).getHostAddress());
            dpInterface.shutdownDPE();
            return;
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:shutdownDPE:exception occurred", exception);
            return;
        }
    }

    public void unregisterForEvents(AppletNotifyInterface appletNotifyInterface) throws RemoteException {
        this.theEventRegistry.removeListener(appletNotifyInterface);
    }

    public void traceDPE(String string) throws RemoteException {
        try {
            DpInterface dpInterface = (DpInterface)this.dpeTable.get(InetAddress.getByName(string).getHostAddress());
            dpInterface.toggleTrace();
            return;
        }
        catch (Exception exception) {
            dpServerImpl.DM("dpServerImpl:getAssignedDPEs:exception occurred", exception);
            return;
        }
    }

    public static void DM(String string) {
        System.out.println(string);
    }

    public static void DM(String string, Exception exception) {
        System.out.println(string);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public Object getConfigLock() {
        return this.configLock;
    }

    static {
        adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
        JDBC_CONNECTION_ERROR = adminRB.getString("s_DBConnectionError");
        JDBC_CLASS_NOT_FOUND_ERROR = adminRB.getString("s_DBClassNotFoundError");
        JDBC_SERVER_CONNECTION_ERROR = adminRB.getString("s_DBServerConnectError");
        versions = new String[]{"1998.07", "1998.12", "1999.03", "1999.05"};
        statAnalyzer = null;
    }
}

